<?php
/**
 * Recent post widget
 * @package automatic
 */

class WP_Automatic_Widget_On_Sale_Products extends WP_Widget {

    public function __construct() {
        $widget_ops = array( 'classname' => 'automatic_widget_on_sale', 'description' => esc_html__( "Display On Sale Products", "automatic") );
        parent::__construct( 'automatic-sale', esc_html__( '[Automatic] On Sale Products', 'automatic' ), $widget_ops );
        $this->alt_option_name = 'automatic_widget_on_sale';
    }

    public function widget( $args, $instance ) {
			echo $args['before_widget'];  
			$args1 = array(
						'post_type' => 'product',
						'post_status' => 'publish',
						'posts_per_page' => 3,
						'no_found_rows'  => 1,   
						'post__in'       => array_merge( array( 0 ), wc_get_product_ids_on_sale() ),
				);
        $rquery = new Wp_Query($args1);
        if ( $rquery -> have_posts() ) :
            echo '<ul class= "pro-widget">';
                while ( $rquery -> have_posts() ) : $rquery -> the_post();
                    wc_get_template_part( 'content', 'product-list' );
                endwhile;
                wp_reset_postdata();
            echo '</ul>';
        endif;
        echo $args['after_widget'];
    }
}